// Toggle Shading.js
// 
// This is macro script. Place it into ~/Library/Application Support/Cheetah3D/scripts/Macro folder.
// 
// To toggle 'shading' of selected object.

function main(doc) {

	if (typeof version == "function" && parseFloat(version()) >= 7) {

		var objs = doc.selectedObjects( true );
		
		for (var i = 0;i < objs.length;i++) {

			var obj = objs[i];

			if (obj.family() == NGONFAMILY) {
				var shading = obj.getParameter("displayType");
				shading = ( shading < 4 )? shading + 1 : 0;
				obj.setParameter("displayType", shading);
			}

		}

	} else {

		var obj = doc.selectedObject();
		
		if ( obj ) {

			var tcount = obj.tagCount();
			for (var i = 0;i < tcount;++i) {
				var tag = obj.tagAtIndex(i);
				info = tag.parameterInfo();
				if (tag.type() == 103) {
					// 
					var shading = tag.getParameter("editorShading");
					shading = ( shading < 3 )? shading + 1 : 0;
					tag.setParameter("editorShading", shading );
				}
			}

		}
	}
}
